/******************************************************************************
 *  [ 1984 oscar (aim) ]                                                      *
 *                                                                            *
 *  pedram amini (pedram@redhive.com)                                         *
 *  pedram.redhive.com                                                        *
 *                                                                            *
 ******************************************************************************/

#define OSCAR_COMMAND_START       0x2a   /* valid oscar command delimiter     */
#define OSCAR_FAMILY_CHAT         0x0e   /* chat room message delimiter       */
#define OSCAR_FAMILY_MESSAGING    0x04   /* regular messaging delimeter       */
#define OSCAR_FAMILY_SIGNON       0x17   /* signon message delimeter          */
#define OSCAR_SIGNON_SUBTYPE      0x02   /* signon message delimeter          */
#define OSCAR_MAX_MESSAGE_LENGTH  1024   /* maximum oscar message length      */
#define OSCAR_MSG_TO_CLIENT       0x07   /* message direction to client       */
#define OSCAR_MSG_FROM_CLIENT     0x06   /* message direction from client     */
#define OSCAR_SN_OFFSET_C         19     /* chat room message sn offset       */
#define OSCAR_SN_OFFSET_M         15     /* regular message sn offset         */
#define OSCAR_SN_OFFSET_S         8      /* signon message sn offset          */
#define OSCAR_MAX_SN_LENGTH       30     /* maximum screenname length         */


/* oscar packet header
 *
 *  |--- 1 byte ----|
 *  +---------------|---------------|---------------|---------------+
 *  |  comm. start  |  channel id   |       sequence number         |
 *  |---------------|---------------|---------------|---------------|
 *  |         data length           |        fnac_family_id         |
 *  |---------------|---------------|-------------------------------|
 *  |    fnac_family_subtype_id     |                               |
 *  +---------------|---------------|---------------|---------------+
 *
 */
struct oscar_header   {
    unsigned command_start:          8;  /* comand start delimiter            */
    unsigned channel_id:             8;  /* we don't use this                 */
    unsigned sequence_number:        16; /* nor this                          */
    unsigned data_length:            16; /* length of oscar data payload      */
    unsigned fnac_family_id:         16; /* message type                      */
    unsigned fnac_family_subtype_id: 16; /* message subtype                   */
};

