/******************************************************************************
 *  [ 1984 ]                                                                  *
 *                                                                            *
 *  pedram amini (pedram@redhive.com)                                         *
 *  pedram.redhive.com                                                        *
 *                                                                            *
 ******************************************************************************/

#include <arpa/inet.h>
#include <ctype.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <pcap.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>
#include <unistd.h>

#include "oscar.h"
#include "toc.h"
#include "msn.h"

#define OSCAR                  5190
#define TOC                    9898
#define MSN                    1863

#define TCPDUMP_FILTER         "tcp src or dst port (5190 or 9898 or 1863)"

#define VERSION                "v1.0"       /* 1984 version                   */
#define BASE_LOG_DIR           "./logs"     /* default log path               */
#define MAX_PATH_LENGTH        1024         /* maximum length of log path     */
#define LOG_PERMS              0755         /* default log file permissions   */

#define IP_H                   0x14         /* ip header size                 */
#define TCP_H                  0x14         /* tcp header size                */

#define PROMISC                1            /* sniff in promiscuous mode?     */
#define SNAPLEN                2000         /* snarf length                   */
#define TO_MS                  1000         /* pcap timeout in milliseconds   */

#define TRUE                   1
#define FALSE                  0

#define EXIT_SUCCESS           0
#define EXIT_FAILURE           1

/* the following defines are used in the below data structures */
#define LI_SIGNON              0
#define LI_MESSAGE             1
#define LI_TO_CLIENT           0
#define LI_FROM_CLIENT         1
#define LI_IP                  12
#define LI_NAME                512
#define LI_MESSAGE             2048

#define OPT_DIR                1024


/* the plus ones in the following data structure buffer definitions are there
   to ensure strncpy null termination */


/* 1984 log information structure */
struct _log_info {
    int  protocol,                          /* protocol (oscar, msn, ...)     */
         log_type,                          /* log type (sign-on or messagte) */
         direction;                         /* message direction (to / from)  */
    char s_addr [LI_IP      + 1],           /* source ip address              */
         d_addr [LI_IP      + 1],           /* destination ip address         */
         s_name [LI_NAME    + 1],           /* source {nick,screen}name       */
         d_name [LI_NAME    + 1],           /* destination {nick,screen}name  */
         message[LI_MESSAGE + 1];           /* chat message                   */
};


/* 1984 options structure */
struct _options {
    char base_log_dir[OPT_DIR + 1];         /* base log directory             */
    int  offset,                            /* datalink offset                */
         flag_daemonize,                    /* daemonize flag                 */
         flag_ps_report,                    /* report stats in 'ps' flag      */
         flag_statistics,                   /* keep statistics flag           */
         flag_verbose,                      /* verbose flag                   */
         num_messages,                      /* number of messages logged      */
         num_words,                         /* number of words logged         */
         num_chars;                         /* number of characters logged    */
};


/* tcp header (the only part we're interested in) */
struct tcphdr   {
    u_int16_t source;                       /* tcp source port                */
    u_int16_t dest;                         /* tcp destination port           */
};


/* function prototypes */
char   *copy_argv   (char **);
void   log_message  (struct _log_info *, struct _options *);
void   log_message  (struct _log_info *, struct _options *);
void   parse        (char *, struct _options *);
pcap_t *set_cap_dev (char *, char *, struct _options *);
void   usage        (char **);

