/******************************************************************************
 *  [ 1984 msn ]                                                              *
 *                                                                            *
 *  pedram amini (pedram@redhive.com)                                         *
 *  pedram.redhive.com                                                        *
 *                                                                            *
 ******************************************************************************/

#include "1984.h"

/******************************************************************************
 *  msn_parse                                                                 *
 *                                                                            *
 *  take a packet: ensure it's a valid msn packet and that we're interested   *
 *  in it, if so format and log it.                                           *
 *  arg1: (char *)            pointer to packet                               *
 *  arg2: (struct _options *) pointer to 1984 options struct                  *
 *  ret:  none                                                                *
 ******************************************************************************/
void
msn_parse (char *packet, struct _options *options)   {
    int i,
        data_size;                             /* msn payload size            */
    struct ip         *ip;                     /* ip header                   */
    struct tcphdr     *tcp;                    /* tcp header                  */
    struct msn_header *msn;                    /* msn header                  */
    struct _log_info  log_info;                /* 1984 log info data struct   */
    char   *data,                              /* pointer to msn payload      */
           *start = NULL,                      /* pointer to start of message */
           *end   = NULL,                      /* pointer to end of message   */
           message[MSN_MAX_MESSAGE_LENGTH+1],  /* html stripped message       */
           user_handle[MSN_USER_HANDLE+1],     /* official user handle        */
           custom_name[MSN_CUSTOM_NAME+1],     /* custom name                 */
           *tmp;

    memset(message,     '\0', MSN_MAX_MESSAGE_LENGTH+1);
    memset(user_handle, '\0', MSN_USER_HANDLE+1);
    memset(custom_name, '\0', MSN_CUSTOM_NAME+1);
    memset(&log_info,   '\0', sizeof(struct _log_info));

    ip   = (struct ip *)           (packet + options->offset);
    tcp  = (struct tcphdr *)       (packet + options->offset + IP_H);
    msn  = (struct msn_header *)   (packet + options->offset + IP_H + TCP_H);
    data = (char *)                (packet + options->offset + IP_H + TCP_H
                                           + sizeof(struct msn_header));

    /* get the byte conversions out of the way */
    ip->ip_len  = ntohs(ip->ip_len);
    tcp->source = ntohs(tcp->source);
    tcp->dest   = ntohs(tcp->dest);

    /* calculate payload size */
    data_size = ip->ip_len - IP_H - TCP_H;

    /* ensure that we have data to analyze */
    if ( !data_size )
        return;

    /* mark the end of the payload (we find the start later) */
    end = (char *)msn + data_size;

    /* we're only interested in the following commands: */
    if ( strncmp(msn->command, "USR", 3) != 0 &&
         strncmp(msn->command, "MSG", 3) != 0 )
            return;

    /* if we are dealing with a signon then log it and return */
    if ( tcp->source == MSN && strncmp(msn->command, "USR", 3) == 0 )  {
        data += 5;

        if ( strncmp(data, "OK", 2) != 0 )
            return;

        /* step over the command */
        data += 3;

        /* find the end of the user handle */
        for (tmp = data; *tmp != ' '; tmp++);

        /* ensure we don't overflow the buffer */
        if ((tmp - data) < MSN_USER_HANDLE)
            i = (tmp - data);
        else
            i = MSN_USER_HANDLE;
        
        /* extract the user handle */
        strncpy(user_handle, data, i);
        
        /* step over the user handle */
        data = tmp + 1;
        
        /* find the end of the custom name */
        for (tmp = data; *tmp != ' '; tmp++);

        /* ensure we don't overflow the buffer */
        if ((tmp - data) < MSN_CUSTOM_NAME)
            i = (tmp - data);
        else
            i = MSN_CUSTOM_NAME;
        
        /* extract the custom name */
        strncpy(custom_name, data, i);
        
        /* fill in the log info struct */
        log_info.protocol = MSN;
        log_info.log_type = LI_SIGNON;

        strncpy(log_info.s_addr, inet_ntoa(ip->ip_dst), LI_IP);
        snprintf(log_info.s_name, LI_NAME, "%s (%s)", user_handle, custom_name);

        log_signon(&log_info, options);
        return;
    }

    /* if we've reached this point we're dealing with a chat message */

    /* message to client */
    if (tcp->source == MSN) {
        log_info.direction = LI_TO_CLIENT;
        
        /* find the end of the user handle */
        for (tmp = ++data; *tmp != ' '; tmp++);

        /* ensure we don't overflow the buffer */
        if ((tmp - data) < MSN_USER_HANDLE)
            i = (tmp - data);
        else
            i = MSN_USER_HANDLE;
        
        /* extract the user handle */
        strncpy(user_handle, data, i);
        
        /* step over the user handle */
        data = tmp + 1;
        
        /* find the end of the custom name */
        for (tmp = ++data; *tmp != ' '; tmp++);

        /* ensure we don't overflow the buffer */
        if ((tmp - data) < MSN_CUSTOM_NAME)
            i = (tmp - data);
        else
            i = MSN_CUSTOM_NAME;
        
        /* extract the custom name */
        strncpy(custom_name, data, i);

        snprintf(log_info.s_name, LI_NAME, "%s (%s)", user_handle, custom_name);
        
        /* locate the start of the message */
        while ( memcmp(data, MSN_DELIMITER, 4) != 0 )
            data++;

        /* skip over the delimeter */
        data += 4;

        if ((end - data) < LI_MESSAGE)
            i = (end - data);
        else
            i = LI_MESSAGE;
        
        strncpy(message, data, i);
    }

    /* message from client */
    if (tcp->dest == MSN) {
        log_info.direction = LI_FROM_CLIENT;

        /* locate the start of the message */
        while ( memcmp(data, MSN_DELIMITER, 4) != 0 )
            data++;

        /* skip over the delimeter */
        data += 4;

        if ((end - data) < LI_MESSAGE)
            i = (end - data);
        else
            i = LI_MESSAGE;
        
        strncpy(message, data, i);
    }
    
    /* make sure there is a message to log */
    if ( strncmp(message, "\x0d\x0a", 2) == 0 )
        return;
    
    /* fill in the remainder of the log_info data struct */
    log_info.protocol = MSN;
    log_info.log_type = LI_MESSAGE;
    
    strncpy(log_info.s_addr, inet_ntoa(ip->ip_src), LI_IP);
    strncpy(log_info.d_addr, inet_ntoa(ip->ip_dst), LI_IP);

    strncpy(log_info.message, message, LI_MESSAGE);

    /* log this entry */
    log_message(&log_info, options);
}

