###############################################################################
# pedbot_command_cset
#
# synopsis:  sets a key/value pair in pedbots internal configuration hash.
# arguments: key, value.
# returns:   new key value combination.

$COMMANDS{cset} = "<key> <value> sets key in pedbots internal configuration "
                . "hash to value (admin only).";

sub pedbot_command_cset {
    my $from  = shift;
    my $key   = shift;
    my @value = @_;
    
    # sanity checking.
    return "admin only command"     if !pedbot_validate_admin($from);
    return "key and value required" if (!$key || !defined($value[0]));
    return "no such key"            if (!$C{uc($key)});
    
    my $value_string = "";
    
    # construct the value string from the args array.
    for (my $i = 0; $i <= $#value; $i++) { $value_string .= "$value[$i] "; }
    
    # update the hash.
    $C{uc($key)} = $value_string;
    
    # update the database.
    my $sql_query = "UPDATE configuration SET _value = '$value_string' "
                  . "                   WHERE _key   = '$key'";
                  
    my $dbquery = $dbhandle->prepare($sql_query);
    
    $dbquery->execute;
    
    $dbquery->finish;
    
    return "$key = $value_string";
}1;