###############################################################################
# pedbot_command_message
#
# synopsis:  leave a message for someone.
# arguments: target screenname, message.
# returns:   message receipt.

$COMMANDS{message} = "<screenname> <message> leave a message for someone, they "
                   . "will get it when they sign on. screename must be one "
                   . "word, no spaces.";

sub pedbot_command_message {
    my $from = shift;
    my $to   = shift;
    my @args = @_;
    
    # sanity checking.
    return "<screename> is a required argument." if (!$to);
    return "<message> is a required argument."   if (!$args[0]);

    if ( $blocked_users{ $aim->normalize($to) } ) {
        return "that person is blocked and can't be messaged.";
    }
    
    my $timestamp = time;
    my $message   = "";
    
    # build the message out of the args array.
    for (my $i = 0; $i <= $#args; $i++) { $message .= "$args[$i] "; }
    
    my $filtered = pedbot_filter_sql($message);
    
    # insert the message into the database.
    my $sql_query = "INSERT INTO messages SET sender    = '$from',"
                                          . " recipient = '$to',"
                                          . " message   = '$filtered',"
                                          . " timestamp = '$timestamp'";
                  
    my $dbquery = $dbhandle->prepare($sql_query);
    
    $dbquery->execute;
    
    $dbquery->finish;
    
    # add the person to the message list.
    $aim->add_buddy(1, $C{GROUP_MESSAGE}, $to);
    
    # if the screenname doesn't already exist in the message hash, put it there.
    $message_queue{$to} = 0 if (!$message_queue{$to});
    
    # reflect the new message in the message hash.
    $message_queue{$to}++;
    
    return "leaving a message for $to: $message";
}1;