###############################################################################
# pedbot_command_pass_gen
#
# synopsis:  generates a random password. there are three modes:
#              pronounceable: all lowercase and pronounceable.
#              ugly:          can contain any printable character.
#              alpha-numeric: contains only alpha-numeric characters.
# arguments: length (optional), mode (optional).
# returns:   password.

$COMMANDS{pass_gen} = "[length] [mode] randomly generate a password. modes include pronounceable, ugly (all printable characters), and alpha-numeric. defaults to pronounceable of length 8.";

sub pedbot_command_pass_gen {
    my $from   = shift;
    my $length = shift;
    my $mode   = lc(shift);
    
    # sanity checking on length.
    if ($length) {
        return "length must be a digit."                 if ($length =~ /[^\d]/);
        return "length exceeds the maximum size of 128." if ($length > 128);
    }

    # sanity checking on mode.
    if ($mode && 
        $mode ne "pronounceable" &&
        $mode ne "ugly"          &&
        $mode ne "alpha-numeric") {
            return "invalid mode, use: pronounceable, ugly, or alpha-numeric";
    }
                    
    
    # set the defaults.
    $length = 8               if (!$length);
    $mode   = "pronounceable" if (!$mode);

    # these are the arrays we use to create pronounceable passwords.
    my @vowels = ("a", "e", "i", "o", "u"); 
    my @cons   = ("b", "c", "d", "g", "h", "j", "k", "l", "m", "n", "p", "r",
                  "s", "t", "u", "v", "w", "tr", "cr", "br", "fr", "th", "dr",
                  "ch", "ph", "wr", "st", "sp", "sw", "pr", "sl", "cl"); 

    # this array is used to create alpha-numeric passwords.
    my @alpha_numeric = split //, "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefgh"
                                . "ijklmnopqrstuvwxyz";

    # create a blank password.
    my $password = "";
                                   
    ### pronounceable mode.
    if ($mode eq "pronounceable") {
        for (my $i = 0; $i < $length; $i++) { 
            $password .= $cons[rand($#cons + 1)] . $vowels[rand($#vowels + 1)]; 
        }
        
        return substr($password, 0, $length);
    }
    
    ### ugly mode.
    if ($mode eq "ugly") {
        for (my $i = 0; $i < $length; $i++) { 
            $password .= chr(rand(94) + 33);
        }
        
        return $password
    }
    
    ### alpha-numeric mode.
    if ($mode eq "alpha-numeric") {
        for (my $i = 0; $i < $length; $i++) { 
            $password .= $alpha_numeric[rand($#alpha_numeric + 1)];
        }
        
        return $password
    }
}1;