###############################################################################
# pedbot_command_spell
#
# synopsis:  ask google for it's spelling advice on a phrase.
# arguments: phrase.
# returns:   spelling advice.

$COMMANDS{spell} = "<phrase> ask google for it's spelling advice.";

sub pedbot_command_spell {
    my $from = shift;
    my @args = @_;
    
    # sanity checking.
    return "<phrase> is a required argument."   if (!$args[0]);

    my ($advice, $google, $query, $result, $rs);

    # build the query out of the args array.
    for (my $i = 0; $i <= $#args; $i++) { $query .= "$args[$i] "; }
    
    # remove the trailing space.
    chop($query);
    
    # from http://groups.yahoo.com/group/soaplite/message/895:
    #     there's a known problem with SOAP::Lite v0.51. boolean type in XML
    #     schema 1999 doesn't accept 'true/false', only '1/0' which is
    #     incorrect.
    # this is the workaround:
    *SOAP::XMLSchema1999::Deserializer::as_boolean    =
    *SOAP::XMLSchemaSOAP1_1::Deserializer::as_boolean =
    \&SOAP::XMLSchema2001::Deserializer::as_boolean;
    
    $google = SOAP::Lite->service("file:support/GoogleSearch.wsdl");
    
    $result = $google->doSpellingSuggestion($C{GOOGLE_KEY}, $query);

    if ($result)    {
        return "google thinks that \"$query\" should be spelled \"$result\".\n";
    }
    
    else    {
        return "google thinks that \"$query\" is spelled just fine.\n";
    }
}1;