###############################################################################
# pedbot_command
#
# synopsis:  this is the pedbot command wrapper. all commands start here. we
#            first check to make sure the command exists and if so pass the
#            arguments over to it, grab the return message, and sent it back
#            to the person who initiated the command.
# arguments: aim pointer, from, command, args.
# returns:   none.

sub pedbot_command {
    my $aim     = shift;
    my $from    = shift;
    my $command = shift;
    my @args    = @_;

    my $log_message = "command from $from: $command ";
    for (my $i = 0; $i <= $#args; $i++) { $log_message .= "$args[$i] "; }
    pedbot_log($log_message);

    $command = "pedbot_command_$command";
    
    my $message;
    my $coderef = *{"$command"}{CODE};
    
    if ($coderef && defined(&$coderef)){ $message = &{$command}($from, @args); }
    else                               { $message = "no such command.";        }
    
    
    return if (!$message);
    
    pedbot_send_im($aim, $from, $C{COMMAND_FONT}, $message);
}1;