###############################################################################
# pedbot_on_update_buddy
#
# synopsis:  this routine is called everytime a buddy signs off or on.
# arguments: 
# returns:   none.

sub pedbot_on_update_buddy {
    my $aim  = shift;
    my $evt  = shift;
    my $from = shift;
    my $to   = shift;
    my $args = $evt->args();
    my ($bud, $online, $evil, $signon_time, $idle_amount, $user_class) = @$args;

    # normalize the persons name.
    my $bud_normalized = $aim->normalize($bud);

    # if buddy signed on.
    if ($online eq 'T' && ! $online_users{$bud_normalized}) {
        $online_users{$bud_normalized} = 1;
        pedbot_debug("signed on: $bud.");
        
        # check to see if the buddy has any awaiting messages.
        if ($message_queue{$bud_normalized}) {
            # construct the message announcement.
            # we are calling a pedbot_command directly here.
            my $message = pedbot_command_mstat($bud);

            # tell our buddy he has messages awaiting.
            pedbot_send_im($aim, $bud, $C{COMMAND_FONT}, $message);
        }
    }
    
    # if buddy signed off.
    elsif ($online eq 'F') {
        delete $online_users{$bud_normalized};
        pedbot_debug("signed off: $bud.");
    }

}1;