###############################################################################
# pedbot_command_mread
#
# synopsis:  prints a messages.
# arguments: message id.
# returns:   message.

$COMMANDS{mread} = "<message id> print a message."; 

sub pedbot_command_mread {
    my $from   = shift;
    my $msg_id = shift;
    
    my $user = $aim->normalize($from);
    
    # sanity checking.
    return "<message id> is a required argument."       if (!defined($msg_id));
    return "invalid characters in message id: $msg_id." if ($msg_id =~ /[^\d]/);
    
    # make sure the message exists.
    if ($msg_id == 0 || $msg_id > $message_queue{$user}) {
        return "no such message.";
    }
    
    # adjust the message id (database is zero indexed message id isn't).
    my $db_msg_id = $msg_id - 1;
    
    # get the message count.
    my $num = $message_queue{$user};
    
    # retrieve the list.
    my $sql_query = "SELECT sender, message, timestamp FROM messages "
                  . "WHERE recipient = '$user' "
                  . "ORDER BY timestamp ASC LIMIT $db_msg_id, 1";
    
    my $dbquery = $dbhandle->prepare($sql_query);
       $dbquery->execute;

    my $result = $dbquery->fetchrow_hashref;

    # construct the timestamp
    my $time      = localtime($result->{timestamp});
    my $timestamp = sprintf("%02d.%02d.%d %02d:%02d:",
                        $time->mon + 1,
                        $time->mday,
                        $time->year + 1900,
                        $time->hour,
                        $time->min);

    $dbquery->finish;
    
    return "$timestamp [$msg_id/$num] message from $result->{sender}\n"
         . "$result->{message}\n";
}1;