###############################################################################
# pedbot_load_message_queue
#
# synopsis:  restores message queue from database to memory (hash).
# arguments: none.
# returns:   none.

sub pedbot_load_message_queue {
    # create a list of users who have messages awaiting as well as how many
    # messages are waiting for them.
    my $sql_query = "SELECT DISTINCT(recipient), COUNT(id) AS mycount FROM "
                  . "messages GROUP BY recipient";
    
    my $dbquery = $dbhandle->prepare($sql_query);
       $dbquery->execute;
    
    # step through the above created list.
    while (my $result = $dbquery->fetchrow_hashref) {
        # update the message count for this user in the queue.
        $message_queue{ $result->{recipient} } = $result->{mycount};
        
        # add this user to the message group for watching.
        $aim->add_buddy(1, $C{GROUP_MESSAGE}, $result->{recipient});
    }
    
    $dbquery->finish;
}1;