###############################################################################
# pedbot_on_error
#
# synopsis:  this routine is called whenever an error is encountered. if the
#            error level is greater than 980 then we drop our DB connection,
#            and exit. (see PROTOCOL for error number meanings).
# arguments: none.
# returns:   none.

sub pedbot_on_error {
    my $aim  = shift;
    my $evt  = shift;
    my $args = $evt->args();
    my ($error, @types) = @$args;
    
    my $errstr =  $evt->trans($error);
    $errstr    =~ s/\$(\d+)/$types[$1]/ge;
    
    pedbot_log("ERROR: $errstr");
    
    # A message has been dropped, you are exceeding the server speed limit.
    if ($error == 903) {
        # XXX - add exceeding speed limit handler.
    }
    
    if ($error > 980) {
        $dbhandle->disconnect();
        
        # XXX - suppress complaints about missing handlers.
        close STDOUT;
        close STDERR;
        
        exit;
    }
}1;