###############################################################################
# pedbot_command_mdel
#
# synopsis:  deletes a messages.
# arguments: message id.
# returns:   message.

$COMMANDS{mdel} = "<message id> delete a message."; 

sub pedbot_command_mdel {
    my $from   = shift;
    my $msg_id = shift;

    my $user = $aim->normalize($from);
    
    # sanity checking.
    return "<message id> is a required argument."       if (!defined($msg_id));
    return "invalid characters in message id: $msg_id." if ($msg_id =~ /[^\d]/);
    
    # make sure the message exists.
    if ($msg_id == 0 || $msg_id > $message_queue{$user}) {
        return "no such message.";
    }
    
    # adjust the message id (database is zero indexed message id isn't).
    my $db_msg_id = $msg_id - 1;
    
    # get the current message count.
    my $num = $message_queue{$user};
    
    # retrieve the message id to delete.
    my $sql_query = "SELECT id FROM messages WHERE recipient = '$user' "
                  . "ORDER BY timestamp ASC LIMIT $db_msg_id, 1";
    
    my $dbquery = $dbhandle->prepare($sql_query);
       $dbquery->execute;

    my $result = $dbquery->fetchrow_hashref;

    my $delete_id = $result->{id};
    
    # delete the message.
    $sql_query = "DELETE FROM messages WHERE id = $delete_id";
    
    $dbquery = $dbhandle->prepare($sql_query);
    $dbquery->execute;
    $dbquery->finish;
    
    # decrement the count in the message_queue.
    $message_queue{$user}--;
    
    # if the queue is empty for this user then
    #   - remove him from message group.
    #   - remove him from the message queue hash.
    if ($message_queue{$user} == 0) {
        $aim->remove_buddy(1, $C{GROUP_MESSAGE}, $user);
        delete $message_queue{$user};
    }
    
    return "message $msg_id of $num deleted.";
}1;