###############################################################################
# pedbot_command_mstat
#
# synopsis:  print a status report of your awaiting messages.
# arguments: none.
# returns:   message status report.

$COMMANDS{mstat} = "print a status report of your awaiting messages.";

sub pedbot_command_mstat {
    my $from = shift;
    
    my $user = $aim->normalize($from);
    
    # if there are no messages for the user let him know.
    return "you have no messages." if (!$message_queue{$user});
    
    # otherwise, get the message count.
    my $num = $message_queue{$user};
    
    # display the status screen.
    return "you have $num messages awaiting.\n"
         . ".mstat      - display this message status message.\n"
         . ".mlist      - list messages.\n"
         . ".mread <id> - read a message.\n"
         . ".mdel  <id> - erase a message.\n"
         . ".mclear     - erase all messages.";
}1;