#!/usr/bin/python

from pytran import *

camera_id       = 200003
window_id       = "0xc00011"
refresh_rate    = 3
color_threshold = 5     # we step through sample values later.

p = pytran(camera_id, window_id, refresh_rate, color_threshold)

p.set_debug_flag(True)
p.grab_frame()
p.rotate()
p.refresh()

start = int(time.time())

print "taking a 5 minute sample at various thresholds."

samples = []
total   = []

while (int(time.time()) < start + 60 * 5):
    p.grab_frame()
    p.gen_diff()
    p.display(p.get_diff())
    p.noraw()

    # take a samples at various thresholds.
    for n in range (51):
        samples.append(0)
        total.append(0)
        if n == 0 or n % 5 != 0:
            continue

        # XXX - without this print statement the below print won't work.
        print

        p.set_color_threshold(n)
        ratio = p.ratio() * 100

        if ratio > 0:
            samples[n] += 1
            total[n]   += ratio
            print "ratio[%d]: %d%%    \r" % (n, ratio),
            sys.stdout.flush()

    p.rotate()
    p.refresh()

for n in range (51):
    if n == 0 or n % 5 != 0:
        continue

    print
    print "5 minute sample[%d]: %.02f" % (n, total[n] / samples[n])
    print
