#!/usr/bin/python

#
# PyTrAn Mask Maker
#

import os
import sys

# command line sanity checking.
try:
    start = int(sys.argv[1])
    end   = int(sys.argv[2])
except:
    sys.stderr.write("Usage: mask_maker <start_num> <end_num>");
    sys.exit(1)

print "Creating a diff for each sequential image pair."

# create a diff for each sequential image pair.
for img in xrange(start, end):
    cmd = "pamarith -diff %d %d > %d.diff" % (img, img + 1, img)
    os.system(cmd)
    print "Diffing %d\r" % img,
    sys.stdout.flush()

print "\n\nCreating the initial mask from the first image pair."

# create the initial mask from the first image pair.
cmd = "pamarith -mul %d.diff %d.diff > mask" % (start, start + 1)
os.system(cmd)

print "\nAdding the rest of the diffs to the mask."

# add the rest of the images to the mask.
for img in xrange(start + 2, end):
    cmd = "pamarith -add mask %d.diff > tmp" % img
    os.system(cmd)
    os.system("mv tmp mask")
    print "Masking %d\r" % img,
    sys.stdout.flush()

print "\n\nDone."