#!/bin/bash

###
# cron.daily script
# recreates daily and weekly conntrack graphs.
# rrd database location: /rrd/
# rrd graph location:    /www/html/rrdgraphs/


rrdtool graph /www/html/rrdgraphs/conntrack_daily.gif    \
        --title "1-day connection tracking"              \
        --width 600                                     \
        --color BACK#333333                              \
        --color SHADEA#000000                            \
        --color SHADEB#000000                            \
        --color CANVAS#000000                            \
        --color GRID#999999                              \
        --color MGRID#666666                             \
        --color FONT#CCCCCC                              \
        --color FRAME#333333                             \
        --start -86400                                   \
        --vertical-label "tracked connections"           \
        --no-legend                                      \
        DEF:nc=/rrd/conntrack.rrd:connections:AVERAGE    \
        AREA:nc#0066FF                                   \
        LINE1:nc#FF0000
        
rrdtool graph /www/html/rrdgraphs/conntrack_weekly.gif   \
        --title "1-week connection tracking"             \
        --width 600                                     \
        --color BACK#333333                              \
        --color SHADEA#000000                            \
        --color SHADEB#000000                            \
        --color CANVAS#000000                            \
        --color GRID#999999                              \
        --color MGRID#666666                             \
        --color FONT#CCCCCC                              \
        --color FRAME#333333                             \
        --start -604800                                  \
        --vertical-label "tracked connections"           \
        --no-legend                                      \
        DEF:nc=/rrd/conntrack.rrd:connections:AVERAGE    \
        AREA:nc#0066FF                                   \
        LINE1:nc#FF0000
        