#!/usr/bin/perl

#
# mysql/rrd temperature recorder
#

use Time::localtime;
use DBI;
$|++;

$outside = "9C0008002E3BA410";
$inside  = "4E0008002E47E110";

$print_flag = shift;
$rrd_flag   = shift;

# database connectivity.
$dbhandle = DBI->connect("DBI:mysql:redhive:localhost:3306",
                         "", "",
                         { RaiseError => 1, AutoCommit => 1 });

# grab the current min/max
$sql_query = "SELECT * FROM temperature";
$dbquery = $dbhandle->prepare($sql_query);
$dbquery->execute;
while ($result = $dbquery->fetchrow_hashref) {
    $outside_min = $result->{celsius} if ( $result->{id} eq "outside_min"  );
    $outside_max = $result->{celsius} if ( $result->{id} eq "outside_max"  );
    $inside_min  = $result->{celsius} if ( $result->{id} eq "inside_min"   );
    $inside_max  = $result->{celsius} if ( $result->{id} eq "inside_max"   );
}
$dbquery->finish;

$keep_looping = 1;
$error_flag   = 0;
@temperatures = ();

# sometimes we don't get a temperature reading. the purpose of this loop is to
# try to get a reading up to 10 times.
for ($error_count = 0; $keep_looping; $error_count++)  {
    break if ($error_count > 10);
    @temperatures = `/usr/local/sbin/temperature`;
    for ($i = 0; $i <= $#temperatures; $i++)  {
        $_ = $temperatures[$i];
        chomp;
        $error_flag++ if (/DEAD/);
        $error_flag++ if ($_ eq "");
    }
    $keep_looping = 0 if (!$error_flag);
    $error_flag   = 0;
    sleep 2;
}

# we should have a reading by now, if not too bad, lets go ahead and record.
for ($i = 0; $i <= $#temperatures; $i++)  {
    $_ = $temperatures[$i];
    chomp;
    next if (/DEAD/);
    next if ($_ eq "");
    print "$_\n" if ($print_flag);
    ($id, $celsius, $fahrenheit) = split(/:/, $_);
    $timestamp = time;

    #
    # OUTSIDE TEMPERATURE
    #
    if ($id eq $outside) {
        # minimum record broken
        if ($celsius < $outside_min) {
            $sql_query = "UPDATE temperature SET celsius = '$celsius', "
                       . "fahrenheit = '$fahrenheit', timestamp = '$timestamp' "
                       . "WHERE id = 'outside_min'";
            $dbquery = $dbhandle->prepare($sql_query);
            $dbquery->execute;
            $dbquery->finish;
        }

        # maximum record broken
        if ($celsius > $outside_max) {
            $sql_query = "UPDATE temperature SET celsius = '$celsius', "
                       . "fahrenheit = '$fahrenheit', timestamp = '$timestamp' "
                       . "WHERE id = 'outside_max'";
            $dbquery = $dbhandle->prepare($sql_query);
            $dbquery->execute;
            $dbquery->finish;
        }

        # update the last record.
        $sql_query = "UPDATE temperature SET celsius = '$celsius', "
                   . "fahrenheit = '$fahrenheit', timestamp = '$timestamp' "
                   . "WHERE id = 'outside_last'";
        $dbquery = $dbhandle->prepare($sql_query);
        $dbquery->execute;
        $dbquery->finish;

        # make an entry in our rrd.
        if (!$rrd_flag)  {
            `rrdtool update /rrd/outside_temperature.rrd N:$fahrenheit`;
            if ($print_flag) {
                print "rrdtool update /rrd/outside_temperature.rrd N:$fahrenheit\n";
            }
        }
    }

    #
    # INSIDE TEMPERATURE
    #
    if ($id eq $inside) {
        # minimum record broken
        if ($celsius < $inside_min) {
            $sql_query = "UPDATE temperature SET celsius = '$celsius', "
                       . "fahrenheit = '$fahrenheit', timestamp = '$timestamp' "
                       . "WHERE id = 'inside_min'";
            $dbquery = $dbhandle->prepare($sql_query);
            $dbquery->execute;
            $dbquery->finish;
        }

        # maximum record broken
        if ($celsius > $inside_max) {
            $sql_query = "UPDATE temperature SET celsius = '$celsius', "
                       . "fahrenheit = '$fahrenheit', timestamp = '$timestamp' "
                       . "WHERE id = 'inside_max'";
            $dbquery = $dbhandle->prepare($sql_query);
            $dbquery->execute;
            $dbquery->finish;
        }

        # update the last record.
        $sql_query = "UPDATE temperature SET celsius = '$celsius', "
                   . "fahrenheit = '$fahrenheit', timestamp = '$timestamp' "
                   . "WHERE id = 'inside_last'";
        $dbquery = $dbhandle->prepare($sql_query);
        $dbquery->execute;
        $dbquery->finish;

        # make an entry in our rrd.
        if (!$rrd_flag)  {
            `rrdtool update /rrd/inside_temperature.rrd N:$fahrenheit`;
            if ($print_flag) {
                print "rrdtool update /rrd/inside_temperature.rrd N:$fahrenheit\n";
            }
        }
    }
}
