#!/bin/bash

###
# cron.daily script
# recreates daily, weekly, monthly, and yearly users graphs.
# rrd database location: /rrd/
# rrd graph location:    /www/html/rrdgraphs/


rrdtool graph /www/html/rrdgraphs/users_daily.gif                        \
        --title "resolution: daily"                                      \
        --width 600                                                     \
        --color BACK#333333                                              \
        --color SHADEA#000000                                            \
        --color SHADEB#000000                                            \
        --color CANVAS#000000                                            \
        --color GRID#999999                                              \
        --color MGRID#666666                                             \
        --color FONT#CCCCCC                                              \
        --color FRAME#333333                                             \
        --start -86400                                                   \
        --vertical-label "# logged in"                                   \
        --no-legend                                                      \
        DEF:numusers=/rrd/users.rrd:users:AVERAGE                        \
        AREA:numusers#0066FF                                             \
        LINE1:numusers#FF0000:users

rrdtool graph /www/html/rrdgraphs/users_weekly.gif                       \
        --title "resolution: weekly"                                     \
        --width 600                                                     \
        --color BACK#333333                                              \
        --color SHADEA#000000                                            \
        --color SHADEB#000000                                            \
        --color CANVAS#000000                                            \
        --color GRID#999999                                              \
        --color MGRID#666666                                             \
        --color FONT#CCCCCC                                              \
        --color FRAME#333333                                             \
        --start -604800                                                  \
        --vertical-label "# logged in"                                   \
        --no-legend                                                      \
        DEF:numusers=/rrd/users.rrd:users:AVERAGE                        \
        AREA:numusers#0066FF                                             \
        LINE1:numusers#FF0000:users