#!/bin/bash

###
# cron.daily script
# recreates daily and weekly conntrack graphs.
# rrd database location: /rrd/
# rrd graph location:    /www/html/rrdgraphs/


rrdtool graph /www/html/rrdgraphs/latency_daily.gif      \
        --title "1-day network latency"                  \
        --width 600                                      \
        --color BACK#333333                              \
        --color SHADEA#000000                            \
        --color SHADEB#000000                            \
        --color CANVAS#000000                            \
        --color GRID#999999                              \
        --color MGRID#666666                             \
        --color FONT#CCCCCC                              \
        --color FRAME#333333                             \
        --start -86400                                   \
        --vertical-label "network latency (ms)"          \
        --no-legend                                      \
        DEF:lat=/rrd/latency.rrd:latency:AVERAGE         \
        LINE3:lat#FF0000                                 \
        AREA:lat#0066FF
        
rrdtool graph /www/html/rrdgraphs/latency_weekly.gif     \
        --title "1-week network latency"                 \
        --width 600                                      \
        --color BACK#333333                              \
        --color SHADEA#000000                            \
        --color SHADEB#000000                            \
        --color CANVAS#000000                            \
        --color GRID#999999                              \
        --color MGRID#666666                             \
        --color FONT#CCCCCC                              \
        --color FRAME#333333                             \
        --start -604800                                  \
        --vertical-label "network latency (ms)"          \
        --no-legend                                      \
        DEF:lat=/rrd/latency.rrd:latency:AVERAGE         \
        LINE3:lat#FF0000                                 \
        AREA:lat#0066FF