#!/bin/bash

###
# cron.daily script
# recreates daily and weekly memory usage graphs.
# rrd database location: /rrd/
# rrd graph location:    /www/html/rrdgraphs/


rrdtool graph /www/html/rrdgraphs/memory_daily.gif       \
        --title "1-day memory usage"                     \
        --width 600                                     \
        --color BACK#333333                              \
        --color SHADEA#000000                            \
        --color SHADEB#000000                            \
        --color CANVAS#000000                            \
        --color GRID#999999                              \
        --color MGRID#666666                             \
        --color FONT#CCCCCC                              \
        --color FRAME#333333                             \
        --start -86400                                   \
        --vertical-label "kilobytes"                     \
        --no-legend                                      \
        DEF:total=/rrd/memory.rrd:total:AVERAGE          \
        DEF:used=/rrd/memory.rrd:used:AVERAGE            \
        DEF:free=/rrd/memory.rrd:free:AVERAGE            \
        LINE1:total#0066FF                               \
        LINE1:used#FF0000                                \
        LINE1:free#00FF00
        
rrdtool graph /www/html/rrdgraphs/memory_weekly.gif      \
        --title "1-day memory usage"                     \
        --width 600                                     \
        --color BACK#333333                              \
        --color SHADEA#000000                            \
        --color SHADEB#000000                            \
        --color CANVAS#000000                            \
        --color GRID#999999                              \
        --color MGRID#666666                             \
        --color FONT#CCCCCC                              \
        --color FRAME#333333                             \
        --start -604800                                  \
        --vertical-label "kilobytes"                     \
        --no-legend                                      \
        DEF:total=/rrd/memory.rrd:total:AVERAGE          \
        DEF:used=/rrd/memory.rrd:used:AVERAGE            \
        DEF:free=/rrd/memory.rrd:free:AVERAGE            \
        LINE1:total#0066FF                               \
        LINE1:used#FF0000                                \
        LINE1:free#00FF00